<!DOCTYPE html>
<html>
<head>
    <title>Select Location with Boundary</title>
    <style>
        #map { height: 500px; width: 100%; }
    </style>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABfBAX-v_a_99NqGylrBuo1mKPnZHx_Go&libraries=places,drawing,geometry"></script>
</head>
<body>
    <h2>Search a Location and Auto-select its Boundary</h2>

    <input id="searchInput" type="text" placeholder="Search city or place" style="width: 400px; height: 30px;">
    <div id="map"></div>

    <form method="POST" action="">
        @csrf
        <input type="hidden" name="name" id="place_name">
        <input type="hidden" name="coordinates" id="coordinates">
        <button type="submit" style="margin-top: 20px;">Save Zone</button>
    </form>

    <script>
        let map, autocomplete, marker, polygon;

        function initMap() {
            map = new google.maps.Map(document.getElementById('map'), {
                center: { lat: 10.0159, lng: 76.3419 },
                zoom: 10
            });

            autocomplete = new google.maps.places.Autocomplete(document.getElementById('searchInput'), {
                types: ['(cities)'] // Limit to cities
            });

            autocomplete.addListener('place_changed', function () {
                const place = autocomplete.getPlace();

                if (!place.geometry || !place.geometry.viewport) {
                    alert("No boundary data available for this place.");
                    return;
                }

                // Clear previous polygon
                if (polygon) polygon.setMap(null);

                // Use geometry.viewport as boundary
                const ne = place.geometry.viewport.getNorthEast();
                const sw = place.geometry.viewport.getSouthWest();

                const boundsCoords = [
                    { lat: ne.lat(), lng: sw.lng() },
                    { lat: ne.lat(), lng: ne.lng() },
                    { lat: sw.lat(), lng: ne.lng() },
                    { lat: sw.lat(), lng: sw.lng() }
                ];

                polygon = new google.maps.Polygon({
                    paths: boundsCoords,
                    strokeColor: "#FF0000",
                    strokeOpacity: 0.8,
                    strokeWeight: 2,
                    fillColor: "#FF0000",
                    fillOpacity: 0.35,
                    map: map,
                    editable: true
                });

                map.fitBounds(place.geometry.viewport);

                // Set hidden fields
                document.getElementById('place_name').value = place.formatted_address || place.name;
                document.getElementById('coordinates').value = JSON.stringify(boundsCoords);
            });
        }

        window.onload = initMap;
    </script>
</body>
</html>
